//ButtonAction.java

import java.awt.*;
import java.awt.event.*;

public class ButtonAction implements ActionListener {

  private TextField  rate_text;
  private TextField  population_text;
  private drawGraph  graphCanvas;
  private double     Rate;
  private double     Population;

  public ButtonAction(TextField rateText, TextField populationText, drawGraph graph) {
    this.rate_text       = rateText;
    this.population_text = populationText;
    this.graphCanvas     = graph;
  }

  public void actionPerformed(ActionEvent ae) {

/* Get the Populatin and Rate String from the TextField and convert the
strings to Double value. If either one of the converted values is out of the
range, pop up a Dialog to inform the user the input value is out of range.
After user read the message in the Dialog and press the OK button in the
Dialog, set the value to Default value, put it in back to the TextField.
Draw the the Graph.   */



    try {
      Population = Double.valueOf(this.population_text.getText()).doubleValue();
      if(Population >= 1.0 || Population <= 0) {
      String warningMessage =
                         new String("Population has to be between 0 and 1.0");

      CreatDialog.creatOKDialog(warningMessage, new Frame());

      throw new Exception ("Invalid value");
      
      }
      

    }
    catch (Exception e) {
      Population = 0.5;
      this.population_text.setText("0.5");
    }


    try {
      Rate = Double.valueOf(this.rate_text.getText()).doubleValue();
      if(Rate >= 4.0 || Rate <= 0){
      String warningMessage = new String("Rate has to be between 0 and 4.0");
      CreatDialog.creatOKDialog(warningMessage, new Frame());
      throw new Exception ("Invalid value");
      }
    }
    catch (Exception e) {
      Rate = 2.8;
      this.rate_text.setText("2.8");
    }

    this.population_text.setText("" + Population);
    this.rate_text.setText("" + Rate);


// Reset the value of rate and population
    graphCanvas.resetRate(Rate);                
    graphCanvas.resetPopulation(Population);
    graphCanvas.repaint();
  }
}
