//MyMenuBar.java


//This class is extends from MenuBar and add Standard items to it.

import java.applet.*;
import java.awt.*;
import java.awt.event.*;


public class MyMenuBar extends MenuBar implements ActionListener {
    
    ClosableFrame frame; 
     
    public MyMenuBar () {
    
      super();
      frame = new ClosableFrame();
      makeFileMenu(this);
      makeEditMenu(this);
      frame.setMenuBar(this);
    }

    


    protected void addItem(Menu m, String s) {
  
      MenuItem mi = new MenuItem(s);
      mi.addActionListener(this);
      m.add(mi); 
    }
  
    void makeEditMenu(MenuBar mb) {
  
      Menu editMenu = new Menu("Edit");
      addItem(editMenu, "Undo");
      editMenu.addSeparator();
      addItem(editMenu, "Cut");
      addItem(editMenu, "Copy");
      addItem(editMenu, "Paste");
      addItem(editMenu, "Clear");
      mb.add(editMenu);
    
    }

    void makeFileMenu(MenuBar mb) {
  
      Menu fileMenu = new Menu("File");
      addItem(fileMenu, "New");
      addItem(fileMenu, "Open...");
      fileMenu.addSeparator();
      addItem(fileMenu, "Close");
      addItem(fileMenu, "Save");
      addItem(fileMenu, "Save As...");
      fileMenu.addSeparator();
      addItem(fileMenu, "Page Setup...");
      addItem(fileMenu, "Print");
      fileMenu.addSeparator();
      addItem(fileMenu, "Quit");
      mb.add(fileMenu);
    
    }

public void actionPerformed(ActionEvent e) {
  
    String choice = (String)e.getActionCommand();
    if(choice.equals("Quit")) {
   
      frame.setVisible(false);
      frame.dispose();
    }  
   }
}  


