//drawGraph.java


// This class is to draw the graph .

import java.awt.*;

class drawGraph extends Canvas {

// r means rate
// p means population

  private double r;
  private double p;
  private int[] yPixel;
  private int scale=2;

// Constructor
  public drawGraph(double inputed_rate,double inputed_population){
    this.r = inputed_rate;
    this.p = inputed_population;
  }

// Paint the graph
  public void paint(Graphics g){

    int max_iteration = 400;
    yPixel = new int[max_iteration];
    Logistic le = new Logistic(r,p,max_iteration);
    yPixel = le.yPixel();

    // Draw the graph
    for(int n=0 ; n < max_iteration ; n+=1) {
       g.drawLine(n*scale,(100-yPixel[n])*scale,(n+1)*scale,(100-yPixel[n+1])*scale);
    }
  }

// Reset the value of rate,and population
  public void resetRate(double inputed_rate){
    r = inputed_rate;
  }
  public void resetPopulation(double inputed_population){
    p = inputed_population;
  }

  public Dimension getMinimumSize(){
    return new Dimension(300,300);
  }

  public Dimension getPreferredSize(){
    return getMinimumSize();
  }
}
